package gov.va.vinci.dart.db.util;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Query;

public abstract class NativeQueryDAO<T> extends HibernateDAO {
	public NativeQueryDAO() {}
	
	public abstract String getQueryText();
	public abstract void populateParameters(final Query q);
	public abstract T buildResult(final Object o);
	
	public List<T> build() {
		
		List<T> result = new ArrayList<T>();
		
		Query q = createNativeQuery(getQueryText());
		populateParameters(q);
		
		for (Object o : q.getResultList()) {
			result.add(buildResult(o));
		}
		
		return result;
	}
}
